%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Matlab Script file for constants 

checkSize = 60.0;  % Length of one side of checker
checksPerSide = 4;
skyGray = round(0.6*255); % Gray level for the sky.
groundGray = round(0.3*255); % Gray level for the ground.

%%% Intrinsic camera parameters
nIm = 128;    % Size of image in pixels
f = nIm/2;    % Focal length for +-45 degrees side to side field of view.
s1 = 2*f/nIm; % Size of pixel in x-direction: 1/s_x in notes
s2 = s1;      % Size of pixel in y-direction: 1/s_y in notes
o1 = (nIm + 1)/2; % Piercing point of optical axis is in
o2 = o1;          % the middle of the image.
%% Matrix for Camera Centered Coords to Pixel Coords.
Mint = [f/s1 0 o1; 0 f/s2 o2; 0 0 1];

%%% Extrinsic camera parameters
% World coordinate frame has X,Y in the the plane of
% the checkerboard, and Z pointing up.

% initial position of pinhole in world frame. 
d0 = [0; 0; 3*f]; 
% i.e., 3*f above the origin of the world frame.

%%% Camera rotation matrix R
% Gives an oblique view
theta = 2/3 * pi;
ct = cos(theta);
st = sin(theta);
R1 = [1 0 0; 0 ct -st; 0 st ct];
theta = 0.05*pi;
ct = cos(theta);
st = sin(theta);
R2 = [ct 0 -st; 0 1 0; st 0 ct];
theta = pi/5;
ct = cos(theta);
st = sin(theta);
R3 = [ct -st 0; st ct 0; 0 0 1];
R0 = R1*R2*R3;
clear R1 R2 R3;

%%%%%%% OPTICAL BLUR STANDARD DEVIATION
sigmaBlur = 0.8;  % sigma for a roughly simulated point spread function
% Does *not* work well for infinite checkerboard.
