
%%% FILE: checkerShow.m
%%% DATE: Sept., 2011
%%% Starter code for CSC420 Assignment 1, Question 1.
%%% Author: ADJ

%%% On completion, this script file will generate images 
%%% of a 3 x 3 checkerboard, illustrating the perspective transform.

clear all;
% close all;

if ~exist('upConv', 'file')
  % upConv.m is in the iseToolbox
  % Set the Matlab path to include both the ise and utvis toolboxes
  % See ../README.txt
  run('../pathReset');
end

if ~exist('gaussFilt', 'file')
  addpath('../util');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%% Constants %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Script file to set the initial 
% intrinsic and extrinsic camera parameters,
% checkerboard parameters.
checkerConstants
      
% Generate 1D gaussian blur filter
radius = 2.5; % In standard deviations
gFilt = gaussFilt(sigmaBlur, radius);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%    Generate an Image    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% The camera's orientation will be changed below. However
% its position in world coordinates should always
% be chosen such that the point (0,0,0)^T in the world coords 
% (i.e., center of the checkerboard) is imaged at 
% the pixel boardCenterPx (in pixels)
boardCenterPx = [0.5*(nIm+1); 0.5 * (nIm + 1); 1]; 
% So the center of checkerboard is imaged at the center of the image.

% The distance between the center of projection for the camera
% and the center of the checkerboard.
distToCenter = 200;

%% Compute a fixed nIm x nIm grid of the coordinates of all the pixels
[xIm,yIm]=meshgrid(1:nIm,1:nIm);
pixCoord = [xIm(:)'; yIm(:)'; ones(1, nIm*nIm)];


% Rotate the camera about its x-axis
for thetaCamX = 0:20:60
  
  % Build factors of the rotation matrix from the
  % world to the camera coordinate frame.
  theta = pi/180 * thetaCamX;
  Rx = [1 0 0; 0 cos(theta) -sin(theta); 0 sin(theta) cos(theta)];
  R1 = Rx * R0;
  
  % Rotate the checkerboard about the Z-axis in the
  % world coordinate frame.
  for thetaSceneZ = 0:20:60
    theta = pi/180 * thetaSceneZ;
    Rz = [cos(theta) -sin(theta) 0; sin(theta) cos(theta) 0; 0 0 1];
    
    % Finally, the world to camera rotation matrix is R
    R = R1*Rz;

    % MODIFY THIS
    % Set the world coordinates of center of projection, namely d,
    % such that the conditions Q1 part a are satisfied.
    d = d0;
      
    % Compute the 3x4 external camera calibration matrix.
    Mext = [R -R*d];

    % Sanity check
    ch = Mint * Mext * [0; 0; 0; 1];
    c  = ch/ch(3);
    % Should both be close to zero
    display([max(abs(c - boardCenterPx)), abs(norm(d) - distToCenter)]);
    
    
    % Set sky to be a logical nIm*nIm by 1 vector, for which
    % sky(k) is true iff the sky region is imaged to the pixel
    % pixCoord(:, k).
    % For non-sky pixels, pixCoord(:, ~sky), set X, Y
    % to be 1 x m vectors, where m = sum(~sky), which
    % provide the (world) coordinates [X; Y; 0] in the ground plane
    % that map to the associated pixel.
    % E.g. if pG = pixCoord(:, ~sky), then pG(:, k) is
    % the image location of the scene point [X(k); Y(k); 0].
    
    % MODIFY THIS
    sky = ones(nIm*nIm, 1) > 0;
    X = [];
    Y = [];
    
    %% Build an image with the 
    im = zeros(nIm* nIm, 1);
    im(:) = skyGray;
    if any(~sky)
       im(~sky) = groundCoordVal(X, Y, ...
                    checkSize, checksPerSide, groundGray);
    end
    
    im = reshape(im, [nIm, nIm]);
    
    % Blur image.
    tmp = upConv(im, gFilt, 'repeat');
    imG = upConv(tmp, gFilt', 'repeat');

    % Display the image.
    figure(1); clf; colormap(gray(256)); 
    image(uint8(imG)); axis equal; axis off;
    
    % Pause for the user to view the image
    fprintf('Press any key to continue...');
    pause;
    fprintf('\n');
  end % over thetaSceneZ
end % over thetaCamX
