function [params, versionStr] = setHoGParams(defaultSz, versionNum)
% [params, versionStr, center, defaultFrame] = ...
%                             setHoGParams(defaultSz, versionNum)
%
% Set HOG params  (Sept 2010 version)
% Simple 1x1, 2x2, 3x3, and 4x4 patterns are given with
% versionNum = 1, 2, 3, and 4 respectively
% The size of each individual cell in these patterns is 
% set to be defaultSz (pixels)

versionStr = ['_h', num2str(defaultSz),'v', num2str(versionNum)];
  
switch versionNum 
 case 1
  % Set the HOG params
  v = getVertexGrid(1,1);
  params = [];
  params.maxAmp = 100;
  params.minAmp = 2;
  params.nTheta = 16;
  params.hogCenter = [0,0];
  params.sx = defaultSz;
  params.sy = defaultSz;
  params.wrapOrient = 0;
  params.minCellNrm = params.minAmp;
  params.vertices = scaleVerts(v, [params.sx, params.sy]);
  
 case 2  
    % Set the HOG params
    v = getVertexGrid(2,2);
    params = [];
    params.maxAmp = 100;
    params.minAmp = 2;
    params.nTheta = 16;
    params.hogCenter = [0,0];
    params.sx = round(defaultSz/2.0);
    params.sy = round(defaultSz/2.0);
    params.wrapOrient = 0;
    params.minCellNrm = params.minAmp;
    params.vertices = scaleVerts(v, [params.sx, params.sy]);
    
 case 3
    % Set the HOG params
    v = getVertexGrid(3,3);
    params = [];
    params.maxAmp = 100;
    params.minAmp = 2;
    params.nTheta = 16;
    params.hogCenter = [0,0];
    params.sx = round(defaultSz/3.0);
    params.sy = round(defaultSz/3.0);
    params.wrapOrient = 0;
    params.minCellNrm = params.minAmp;
    params.vertices = scaleVerts(v, [params.sx, params.sy]);

 case 4
    % Set the HOG params
    v = getVertexGrid(4,4);
    params = [];
    params.maxAmp = 100;
    params.minAmp = 2;
    params.nTheta = 16;
    params.hogCenter = [0,0];
    params.sx = round(defaultSz/4.0);
    params.sy = round(defaultSz/4.0);
    params.wrapOrient = 0;
    params.minCellNrm = params.minAmp;
    params.vertices = scaleVerts(v, [params.sx, params.sy]);

 otherwise
  error('Unrecognized version number');
end

% Define bounding boxes of size sx by sy, centered
% on each vertex.  Express these bounding boxes in terms of
% pixels from the center point.
nCell = length(params.vertices);
cellBox = 0.5*[-params.sx, -params.sy; params.sx params.sy]; 
for kCell = 1:nCell

  xy0 = params.vertices(kCell).xy - params.hogCenter;
  bbox = cellBox + repmat(xy0, 2,1);
  params.cellBox(kCell).bbox = bbox; 
  
end 

