function [g, gx, gxx] = gaussFilt(sigma, rho)
%  [g, gx, gxx] = gaussFilt(sigma, rho)
% One dimensional Gaussian filter (and d/dx , d^2/dx^2)
% for a given sigma
% Filters is have length 2*round(rho * sigma) + 1.
% rho radius of filter in sigma, [Default rho = 3.5]
% Note 
%   rho = 2.5 is ok if you only want g, 
%         3 is ok if you want gx as well, 
%         3.5 better if you also want gxx.
  
  if nargin < 2
    rho = 3.5;
  end
  sigmaSqr = sigma*sigma;
  gSize = 2 * round(rho * sigma) + 1;
  x = [1:gSize] - round((gSize+1)/2);
  g = exp(- x .* x / (2.0*sigmaSqr));
  scl = sum(g(:));
  g = g / sum(g(:));
  gx = - (x / sigmaSqr) .* g;
  gxx = (x.^2/(sigmaSqr*sigmaSqr) - 1/sigmaSqr) .* g;
  return;
